/********************************************************
Filename		:  lab_analytical_proc.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Lab Analytical Procedure table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/15/2006.
Comments		:  
**********************************************************/

/***********************************************************
Create sequences for MetaData Lab Analytical Procedure table
************************************************************/
set echo on 
spool lab_analytical_proc.log
--drop sequence seq_md_analytical_proc;

create sequence seq_md_analytical_proc
start with 1 increment by 1 nomaxvalue nocycle cache 10;
/*********************************************
Create MetaData Lab Analytical Procedure table
**********************************************/
--drop table md_analytical_proc;

create table md_analytical_proc
( pk_isn number(12,0),
  organization_id VARCHAR2(256 char) not null,
  anlpr_is_number number(12,0) not null,
  procedure_source VARCHAR2(256 char),
  procedure_id VARCHAR2(256 char) not null,
  procedure_name VARCHAR2(256 char) not null,
  citation VARCHAR2(4000 char),
  equipment_name VARCHAR2(256 char),
  national_proc_id VARCHAR2(256 char));
  
alter table md_analytical_proc
add constraint pk_analy_proc primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

create index ianlorgid on md_analytical_proc(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;
/* moved to end of insert block
alter table md_analytical_proc add organization_is_number number(8,0);

update md_analytical_proc ap
set organization_is_number = (select organization_is_number from di_org o where o.organization_id = ap.organization_id);

commit;

 
alter table md_analytical_proc
add( fk_org number(12,0));

update md_analytical_proc ap
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=ap.organization_is_number)
where ap.organization_is_number is not null;
commit;

create index ianlfk on md_analytical_proc(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_analytical_proc
add constraint fk_md_anlp foreign key (fk_org) references di_org(pk_isn);

commit;

*/
/*********************************************************
Populate MetaData Lab Analytical Procedure table with data.
**********************************************************/
set serveroutput on
declare
CITATION_DESC VARCHAR2(4000);
v_eq_name VARCHAR2(60);
v_cnat_proc_id CHAR(27);
cursor c_analy_proc is 
select TSRANLPR_ORG_ID,TSRANLPR_IS_NUMBER,TSRANLPR0IS_NUMBER,TSRANLPR0ORG_ID,SOURCE_ACR,PROCEDURE_ID,NAME,TSRCITN_ORG_ID,TSRCITN_IS_NUMBER,TSRANLEQ_ORG_ID,TSRANLEQ_IS_NUMBER
from storet1.tsranlpr
where TSRANLPR_ORG_ID != 'ZZZZZZZZ'; 

begin
 
for c_var in c_analy_proc loop
  begin
    select decode(CI.IDENTIFICATION_CD,null,null,trim(CI.IDENTIFICATION_CD)||',')||decode(CI.AUTHOR_NAME,null,null,trim(CI.AUTHOR_NAME)||',')||decode(CI.PUBLICATION_YEAR,null,null,trim(CI.PUBLICATION_YEAR)||',')||decode(CI.TITLE_NAME,null,null,trim(CI.TITLE_NAME)||',')||decode(CI.JRNL_OR_PBLSHR_NM,null,null,trim(CI.JRNL_OR_PBLSHR_NM)||',')||decode(CI.VOL_AND_PG_NUM,null,null,trim(CI.VOL_AND_PG_NUM)) INTO CITATION_DESC
    from storet1.tsrcitn CI
    where CI.tsrcitn_org_id = c_var.tsrcitn_org_id 
    and CI.tsrcitn_is_number = c_var.tsrcitn_is_number;
  exception when no_data_found then 
    CITATION_DESC:=null;
    null;
 end;
  
   begin
    select EQ.NAME INTO v_eq_name
    from storet.tsranleq EQ
    where EQ.tsranleq_org_id = c_var.tsranleq_org_id
    and EQ.tsranleq_is_number = c_var.tsranleq_is_number;
  exception when no_data_found then
    v_eq_name:=null;
    null;
  end;
  
  begin
    select  decode(NP.SOURCE_ACR,null,null,trim(NP.SOURCE_ACR)||'/')|| decode(NP.PROCEDURE_ID,null,null,trim(NP.PROCEDURE_ID)) INTO v_cnat_proc_id
    from  storet1.tsranlpr NP
    where c_var.tsranlpr0is_number= NP.tsranlpr_is_number (+)
    and c_var.tsranlpr0org_id =NP.tsranlpr_org_id (+);
    exception when no_data_found then
    v_cnat_proc_id:=null;
    null;
  end;
    
    insert into md_analytical_proc
    (pk_isn,organization_id,anlpr_is_number,procedure_source,procedure_id,procedure_name,citation,equipment_name,national_proc_id)
    values
    (seq_md_analytical_proc.nextval,c_var.tsranlpr_org_id,c_var.tsranlpr_is_number,c_var.source_acr,c_var.procedure_id,c_var.name,citation_desc,v_eq_name,v_cnat_proc_id);
end loop;
commit;
end;
/
show errors
commit;

alter table md_analytical_proc add organization_is_number number(8,0);

update md_analytical_proc ap
set organization_is_number = (select organization_is_number from di_org o where o.organization_id = ap.organization_id);

commit;
 
alter table md_analytical_proc
add( fk_org number(12,0));

update md_analytical_proc ap
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=ap.organization_is_number)
where ap.organization_is_number is not null;
commit;

create index ianlfk on md_analytical_proc(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_analytical_proc
add constraint fk_md_anlp foreign key (fk_org) references di_org(pk_isn);

commit;

alter table md_analytical_proc add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_analytical_proc add SOURCE_UID NUMBER(20);
commit;

alter table md_analytical_proc modify anlpr_is_number number(12,0) null;


spool off;
